<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->integer('category_id')->unsigned();
			$table->integer('sub_category_id')->unsigned();
			$table->smallInteger('status_id')->default('0');
			$table->boolean('is_active')->default(1);
			$table->string('model_type', 191);
			$table->integer('model_id')->unsigned();
			$table->integer('owner_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}