<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->string('title');
			$table->string('excerpt');
			$table->string('body');
			$table->longText('image');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}