<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    public function variant_products()
    {
        return $this->hasMany('ProductVariant', 'product_id');
    }

    public function attributes()
    {
        return $this->belongsToMany('ProductAttributeReletionship', 'product_attribute_reletionship')->withTimestamps();
    }

}