<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantsTable extends Migration {

	public function up()
	{
		Schema::create('product_variants', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id');
			$table->string('sku');
			$table->text('descriptions');
			$table->text('short_decriptions');
			$table->decimal('mrp');
			$table->decimal('sales_price');
			$table->string('quantity');
			$table->tinyInteger('is_default');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_variants');
	}
}