<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Complain extends Model 
{

    protected $table = 'complains';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function complain_meta()
    {
        return $this->hasMany('ComplainMeta');
    }

    public function user()
    {
        return $this->hasOne('User');
    }

    public function order()
    {
        return $this->hasOne('Order');
    }

}