<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned();
			$table->bigInteger('landlord_id')->unsigned();
			$table->bigInteger('tenant_id')->unsigned();
			$table->string('invoice_number')->unique();
			$table->double('sub_amount');
			$table->double('vat_amount');
			$table->double('total_amount');
			$table->date('date');
			$table->longText('comments')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}