<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('landlord_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rent_details', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('landlord_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('contracts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_landlord_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_tenant_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_property_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_unit_id_foreign');
		});
		Schema::table('rent_details', function(Blueprint $table) {
			$table->dropForeign('rent_details_contract_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_contract_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_landlord_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_tenant_id_foreign');
		});
	}
}