<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('managers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('owners', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->foreign('maintenance_type_id')->references('id')->on('maintenance_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('worker_maintenance_types', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('workers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('worker_maintenance_types', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->foreign('maintenance_type_id')->references('id')->on('maintenance_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->foreign('worker_id')->references('id')->on('workers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->foreign('period_id')->references('id')->on('periods')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->foreign('building_id')->references('id')->on('buildings')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('maitenance_orders')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('managers')
						->onDelete('set null')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('managers', function(Blueprint $table) {
			$table->dropForeign('managers_city_id_foreign');
		});
		Schema::table('owners', function(Blueprint $table) {
			$table->dropForeign('owners_city_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_id_foreign');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->dropForeign('buildings_owner_id_foreign');
		});
		Schema::table('buildings', function(Blueprint $table) {
			$table->dropForeign('buildings_manager_id_foreign');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->dropForeign('building_invoices_building_id_foreign');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->dropForeign('building_invoices_manager_id_foreign');
		});
		Schema::table('building_invoices', function(Blueprint $table) {
			$table->dropForeign('building_invoices_user_id_foreign');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->dropForeign('workers_maintenance_type_id_foreign');
		});
		Schema::table('workers', function(Blueprint $table) {
			$table->dropForeign('workers_manager_id_foreign');
		});
		Schema::table('worker_maintenance_types', function(Blueprint $table) {
			$table->dropForeign('worker_maintenance_types_worker_id_foreign');
		});
		Schema::table('worker_maintenance_types', function(Blueprint $table) {
			$table->dropForeign('worker_maintenance_types_building_id_foreign');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->dropForeign('maitenance_orders_user_id_foreign');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->dropForeign('maitenance_orders_building_id_foreign');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->dropForeign('maitenance_orders_maintenance_type_id_foreign');
		});
		Schema::table('maitenance_orders', function(Blueprint $table) {
			$table->dropForeign('maitenance_orders_worker_id_foreign');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->dropForeign('rentals_building_id_foreign');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->dropForeign('rentals_user_id_foreign');
		});
		Schema::table('rentals', function(Blueprint $table) {
			$table->dropForeign('rentals_period_id_foreign');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->dropForeign('entitlements_user_id_foreign');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->dropForeign('entitlements_building_id_foreign');
		});
		Schema::table('entitlements', function(Blueprint $table) {
			$table->dropForeign('entitlements_manager_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_order_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_plan_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_manager_id_foreign');
		});
	}
}