<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCvsTable extends Migration {

	public function up()
	{
		Schema::create('cvs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 35);
			$table->string('second_name', 35);
			$table->string('third_name', 35);
			$table->string('last_name', 35);
			$table->string('identification_number', 10)->nullable();
			$table->string('phone', 10);
			$table->integer('job_id')->unsigned();
			$table->string('cv_file')->nullable();
			$table->integer('status')->default('1');
			$table->string('reject_resone', 50)->nullable();
			$table->date('deactivated_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cvs');
	}
}