<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactUsTable extends Migration {

	public function up()
	{
		Schema::create('contact_us', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->string('name')->nullable();
			$table->string('mobile')->nullable();
			$table->text('message')->nullable();
			$table->enum('status', array('new', 'closed'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contact_us');
	}
}