<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Influencer extends Model 
{

    protected $table = 'influencers';
    public $timestamps = true;
    protected $fillable = array('first_name', 'last_name', 'email', 'phone_number', 'address_1', 'address_2', 'city', 'postal_code', 'status', 'country_id', 'state_id', 'gender', 'age', 'instagram_profile', 'rating', 'user_id', 'data');
    protected $visible = array('first_name', 'last_name', 'email', 'phone_number', 'address_1', 'address_2', 'city', 'postal_code', 'country_id', 'state_id', 'gender', 'age', 'instagram_profile', 'rating', 'user_id', 'data');

    public function user()
    {
        return $this->belongsTo('Users');
    }

    public function country()
    {
        return $this->hasOne('Country');
    }

    public function state()
    {
        return $this->hasOne('\State');
    }

    public function businesses()
    {
        return $this->hasManyThrough('\Business')->withPivot('business_influencers_pivot');
    }

    public function campaigns()
    {
        return $this->hasManyThrough('CampaignInfluencer')->withPivot('campaign_influencer_pivot');
    }

}