<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 256)->nullable();
			$table->text('description');
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->string('status', 28);
			$table->integer('business_id')->unsigned();
			$table->integer('user_id')->unsigned()->default('0');
			$table->string('subscription')->nullable();
			$table->bigInteger('post_count')->unsigned()->default('0');
			$table->timestamps();
			$table->json('data')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}