<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfluencersTable extends Migration {

	public function up()
	{
		Schema::create('influencers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email')->nullable();
			$table->string('phone_number')->nullable();
			$table->string('address_1');
			$table->string('address_2')->nullable();
			$table->string('city');
			$table->string('postal_code', 25)->nullable();
			$table->string('status');
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('state_id')->unsigned()->nullable();
			$table->string('gender')->nullable();
			$table->integer('age')->nullable();
			$table->string('instagram_profile')->nullable();
			$table->integer('rating')->nullable()->default('0');
			$table->integer('user_id')->unsigned();
			$table->json('data');
		});
	}

	public function down()
	{
		Schema::drop('influencers');
	}
}