<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('is_active')->default('0');
			$table->integer('object_id')->nullable();
			$table->string('object_type', 64)->nullable();
			$table->smallInteger('plan_id')->unsigned();
			$table->integer('business_id')->unsigned()->nullable();
			$table->string('merchant_subscription_id', 500)->nullable();
			$table->tinyInteger('auto_expire')->default('0');
			$table->datetime('expires_on')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}