<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessesTable extends Migration {

	public function up()
	{
		Schema::create('businesses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('business_name', 128);
			$table->string('email', 64)->nullable();
			$table->string('phone_number', 64)->nullable();
			$table->string('address_1', 128)->nullable();
			$table->string('address_2', 64)->nullable();
			$table->string('city', 64)->nullable();
			$table->string('postal_code', 26)->nullable();
			$table->string('owner_name', 64)->nullable();
			$table->string('owner_email', 64)->nullable();
			$table->string('owner_phone', 64)->nullable();
			$table->string('poc_name', 64)->nullable();
			$table->string('poc_email', 64)->nullable();
			$table->string('poc_phone', 64)->nullable();
			$table->string('website')->nullable();
			$table->string('status', 64)->nullable();
			$table->integer('country_id')->unsigned()->nullable()->default('0');
			$table->integer('state_id')->unsigned()->nullable()->default('0');
			$table->integer('subscription_id')->unsigned()->nullable()->default('0');
			$table->integer('user_id')->unsigned()->nullable();
			$table->text('request_message')->nullable();
			$table->string('merchant_customer_id', 128)->nullable();
			$table->string('merchant_descriptor', 64)->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->json('data')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('businesses');
	}
}