<?php

class Offer extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;
	protected $fillable = array('business_id', 'type', 'value', 'description', 'campaign_id', 'influencer_id', 'data');
	protected $visible = array('business_id', 'type', 'value', 'description', 'campaign_id', 'influencer_id', 'data');

	public function business()
	{
		return $this->belongsTo('Business');
	}

	public function influencer()
	{
		return $this->belongsTo('Influencer');
	}

	public function campaign()
	{
		return $this->belongsTo('Campaign');
	}

}