<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateKeywordsTable extends Migration {

	public function up()
	{
		Schema::create('keywords', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('status');
			$table->integer('created_by_user_id')->unsigned();
			$table->integer('updated_by_user_id')->unsigned();
			$table->integer('requested_by_user_id')->unsigned();
			$table->datetime('requested_on')->nullable();
			$table->string('requested_type')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('keywords');
	}
}