<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lesson_faq', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_availibiity', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_availibiity', function(Blueprint $table) {
			$table->foreign('tutor_availability_id')->references('id')->on('tutor_availability')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sample_videos', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('lesson_faq', function(Blueprint $table) {
			$table->dropForeign('lesson_faq_lesson_id_foreign');
		});
		Schema::table('lesson_availibiity', function(Blueprint $table) {
			$table->dropForeign('lesson_availibiity_lesson_id_foreign');
		});
		Schema::table('lesson_availibiity', function(Blueprint $table) {
			$table->dropForeign('lesson_availibiity_tutor_availability_id_foreign');
		});
		Schema::table('sample_videos', function(Blueprint $table) {
			$table->dropForeign('sample_videos_lesson_id_foreign');
		});
	}
}