<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('registered_property_documents_hmo_case', function(Blueprint $table) {
			$table->foreign('registered_property_document_id')->references('id')->on('registered_property_documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('registered_property_documents_hmo_case', function(Blueprint $table) {
			$table->foreign('hmo_case_id')->references('id')->on('hmo_cases')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('registered_property_documents_hmo_case', function(Blueprint $table) {
			$table->dropForeign('registered_property_documents_hmo_case_registered_property_document_id_foreign');
		});
		Schema::table('registered_property_documents_hmo_case', function(Blueprint $table) {
			$table->dropForeign('registered_property_documents_hmo_case_hmo_case_id_foreign');
		});
	}
}