<?php

namespace UserDevice;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserDevice extends Model 
{

    protected $table = 'user_devices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_code', 'mobile', 'device_type', 'device_token', 'is_logout');

    public function getUser()
    {
        return $this->hasOne('User', 'user_id');
    }

}