<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripHistoryTable extends Migration {

	public function up()
	{
		Schema::create('trip_history', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('trip_id');
			$table->integer('driver_id');
			$table->string('title', 250)->nullable();
			$table->decimal('latitude', 10,5)->nullable();
			$table->decimal('longitude', 10,5)->nullable();
			$table->string('waiting_time', 250)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('trip_history');
	}
}