<?php

namespace Notification;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'slug', 'message', 'image', 'is_read');

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

	public function getTrip()
	{
		return $this->hasOne('Trip', 'trip_id');
	}

}