<?php

namespace UserOtp;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserOtp extends Eloquent {

	protected $table = 'user_otp';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'otp', 'status');

	public function getUser()
	{
		return $this->hasOne('User', 'user_id');
	}

}