<?php

namespace Driver;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Model 
{

    protected $table = 'driver_users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'country_code', 'mobile', 'email', 'image', 'grade', 'balance', 'remember_token');

    public function getGrade()
    {
        return $this->hasOne('DriverGrade', 'grade');
    }

}