<?php

namespace UserOtp;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserOtp extends Model 
{

    protected $table = 'user_otp';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'otp', 'status');

    public function getUser()
    {
        return $this->hasOne('User', 'user_id');
    }

}