<?php

namespace UserWallet;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserWallet extends Model 
{

    protected $table = 'user_wallets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('earned', 'redeemed');

    public function getUser()
    {
        return $this->hasOne('User', 'user_id');
    }

}