<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamsTable extends Migration {

	public function up()
	{
		Schema::create('exams', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->bigInteger('course_id')->unsigned()->nullable()->index();
			$table->datetime('due_date');
			$table->time('time_limit');
			$table->bigInteger('section_id')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('exams');
	}
}