<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentExamTable extends Migration {

	public function up()
	{
		Schema::create('student_exam', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('student_id')->unsigned()->index();
			$table->bigInteger('course_id')->unsigned()->index();
			$table->bigInteger('exam_id')->unsigned()->index();
			$table->time('start_time');
			$table->string('end_time');
			$table->double('points');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('student_exam');
	}
}