<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Trade extends Model 
{

    protected $table = 'trades';
    public $timestamps = true;

    public function trade_player()
    {
        return $this->hasOne('Models\TradesPlayers', 'trade_id', 'id');
    }

    public function trade_teams()
    {
        return $this->hasMany('Models\TradesTeams', 'trade_id', 'id');
    }

    public function user()
    {
        return $this->hasOne('Models\User', 'id', 'user_id');
    }

}