<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayersTable extends Migration {

	public function up()
	{
		Schema::create('players', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('team_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('abbr_name')->nullable();
			$table->datetime('birthday')->nullable();
			$table->string('position')->nullable();
			$table->string('status')->nullable();
			$table->string('owner')->nullable();
			$table->string('preferred_name')->nullable();
			$table->double('weight')->nullable();
			$table->integer('height')->nullable();
			$table->string('birth_place')->nullable();
			$table->string('high_school')->nullable();
			$table->string('college')->nullable();
			$table->string('college_conf')->nullable();
			$table->integer('rookie_year')->nullable();
			$table->integer('draft_year')->nullable();
			$table->integer('draft_round')->nullable();
			$table->integer('draft_number')->nullable();
			$table->integer('draft_team_id')->nullable();
			$table->string('avatar');
			$table->integer('depth');
		});
	}

	public function down()
	{
		Schema::drop('players');
	}
}