<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('league_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->string('name')->nullable();
			$table->string('avatar');
			$table->string('abbreviation');
			$table->integer('winnings');
			$table->tinyInteger('is_commissioner');
			$table->decimal('points');
			$table->decimal('points_last');
			$table->integer('position');
			$table->decimal('auction_budget');
			$table->timestamp('accepted_terms');
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}