<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesTable extends Migration {

	public function up()
	{
		Schema::create('notes', function(Blueprint $table) {
			$table->string('stagiaire_id');
			$table->string('note_id')->unique()->primary();
			$table->integer('note_value');
			$table->boolean('is_evaluation_miparcours')->default(false );
			$table->boolean('is_evaluation_finale');
			$table->string('module_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('notes');
	}
}