<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannerTable extends Migration {

	public function up()
	{
		Schema::create('banner', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 256)->nullable();
			$table->text('image')->nullable();
			$table->tinyInteger('type')->default('0');
			$table->text('url')->nullable();
			$table->integer('order')->default('0');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('banner');
	}
}