<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryAttributesSizeTable extends Migration {

	public function up()
	{
		Schema::create('category_attributes_size', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('attribute_id')->unsigned();
			$table->text('size')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('category_attributes_size');
	}
}