<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductRequestTable extends Migration {

	public function up()
	{
		Schema::create('product_request', function(Blueprint $table) {
			$table->increments('id');
			$table->string('enquiry_type', 256)->nullable();
			$table->string('name', 256)->nullable();
			$table->integer('contact')->nullable();
			$table->string('email', 256)->nullable();
			$table->text('message')->nullable();
			$table->string('mode_of_contact', 256)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_request');
	}
}