<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 191);
			$table->string('email', 191);
			$table->string('password', 60);
			$table->text('two_factor_secret')->nullable();
			$table->text('two_factor_recovery_codes');
			$table->string('remember_token', 100);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->bigIncrements('space_available');
			$table->string('language', 6);
			$table->string('country', 40);
			$table->string('timezone', 30);
			$table->string('avatar', 191);
			$table->string('stripe_id', 191);
			$table->bigIncrements('available_space');
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->text('legacy_permissions');
			$table->string('card_brand', 191);
			$table->string('card_last_four', 191);
			$table->timestamp('email_verified_at');
			$table->string('card_expires', 10);
			$table->string('paypal_id', 20);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}