<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertsTable extends Migration {

	public function up()
	{
		Schema::create('experts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('affiliation')->nullable();
			$table->longText('expertise')->nullable();
			$table->string('status', 20)->default('active');
		});
	}

	public function down()
	{
		Schema::drop('experts');
	}
}