<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('about_contents', function(Blueprint $table) {
			$table->foreign('about_id')->references('id')->on('about')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('research_categories', function(Blueprint $table) {
			$table->foreign('lead')->references('id')->on('experts')
						->onDelete('restrict')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('about_contents', function(Blueprint $table) {
			$table->dropForeign('about_contents_about_id_foreign');
		});
		Schema::table('research_categories', function(Blueprint $table) {
			$table->dropForeign('research_categories_lead_foreign');
		});
	}
}