<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountsTable extends Migration {

	public function up()
	{
		Schema::create('bank_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('account_name')->nullable();
			$table->string('account_number')->nullable();
			$table->string('first_name')->nullable();
			$table->string('iban')->nullable();
			$table->string('email')->nullable();
			$table->string('image')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bank_accounts');
	}
}