<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

}