<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('fname', 250);
			$table->string('lname', 250);
			$table->string('preferedUsername');
			$table->string('email');
			$table->integer('role_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->string('driving_licence');
			$table->string('driving_licence_expired_date');
			$table->string('password');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}