<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 255);
			$table->string('summary', 255);
			$table->text('description');
			$table->integer('language_id')->unsigned();
			$table->integer('skill_level')->default('0');
			$table->timestamp('published_at')->nullable();
			$table->boolean('free')->default(true);
			$table->decimal('price', 8,2);
			$table->integer('instractor_id')->unsigned();
			$table->string('image', 255)->nullable();
			$table->integer('sub_category_id')->unsigned();
			$table->text('congratulations_message')->nullable();
			$table->text('welcome_message')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}