<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('students', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->rememberToken('rememberToken');
			$table->string('image', 255)->nullable();
			$table->string('twitter_url', 255)->nullable();
			$table->string('facebook_url', 255)->nullable();
			$table->string('LinkedIn_url', 255)->nullable();
			$table->text('description')->nullable();
			$table->boolean('show_profile')->default(true);
			$table->boolean('show_cources')->nullable()->default(true);
			$table->timestamp('verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('students');
	}
}