<?php

namespace App\Models;

class Student extends Eloquent {

	protected $table = 'students';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'password', 'rememberToken', 'image', 'twitter_url', 'facebook_url', 'LinkedIn_url', 'description', 'show_profile', 'show_cources', 'verified_at');
	protected $hidden = array('password', 'rememberToken');

	public function instractor()
	{
		return $this->hasOne('App\Models\Instractors');
	}

	public function reviews()
	{
		return $this->belongsToMany('App\Models\Course', 'student_review')->withPivot(['rate','description']);
	}

	public function wishlists()
	{
		return $this->belongsToMany('App\Models\Course', 'wishlists');
	}

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill', 'student_skill');
	}

	public function leacturesCompleted()
	{
		return $this->belongsToMany('App\Models\Leacture', 'student_leacture')->withPivot('note');
	}

	public function courses()
	{
		return $this->belongsToMany('App\Models\Course', 'enrollments');
	}

	public function cartItems()
	{
		return $this->belongsToMany('App\Models\Course', 'carts')->withPivot('price');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function instractorsReports()
	{
		return $this->morphedByMany('App\Models\Instractors', 'reportable')->withPivot('description');
	}

	public function coursesReports()
	{
		return $this->morphedByMany('App\Models\Course', 'reportable')->withPivot('description');
	}

	public function leacturesReports()
	{
		return $this->morphedByMany('App\Models\Leacture', 'reportable')->withPivot('description');
	}

}