<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseSpecialNeed extends Model 
{

    protected $table = 'house_special_need';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'orphan_id', 'donation_category_id', 'title_en', 'title_ar', 'description_en', 'description_ar', 'requested_date', 'fulfilled_date', 'status', 'expected_price', 'due_date');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

    public function orphan()
    {
        return $this->belongsTo('Orphan', 'orphan_id');
    }

    public function donation_category()
    {
        return $this->belongsTo('DonationCategory', 'donation_category_id');
    }

}