<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseStaff extends Model 
{

    protected $table = 'house_staff';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'type', 'name_en', 'name_ar', 'phone', 'email', 'join_date', 'biography_en', 'biography_ar', 'details_en', 'details_ar', 'status', 'departure_date');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

}