<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseTable extends Migration {

	public function up()
	{
		Schema::create('house', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en', 100)->nullable();
			$table->string('name_ar')->nullable();
			$table->string('government_license_en')->nullable();
			$table->string('government_license_ar')->nullable();
			$table->text('address_en')->nullable();
			$table->text('address_ar')->nullable();
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->integer('current_child_count')->nullable();
			$table->double('average_age')->nullable();
			$table->integer('child_capacity')->nullable();
			$table->string('responsible_name_en', 100)->nullable();
			$table->string('responsible_name_ar')->nullable();
			$table->string('responsible_phone', 20)->nullable();
			$table->string('phone')->nullable();
			$table->date('establishment_date')->nullable();
			$table->text('activity_program')->nullable();
			$table->string('email')->nullable();
			$table->text('biography_en')->nullable();
			$table->text('biography_ar')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house');
	}
}