<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseGallery extends Model 
{

    protected $table = 'house_gallery';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_en', 'title_ar', 'house_id');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

}