<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HouseProgramActivity extends Model 
{

    protected $table = 'house_program_activity';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('house_id', 'name_en', 'name_ar', 'details_en', 'details_ar');

    public function house()
    {
        return $this->belongsTo('House', 'house_id');
    }

}