<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrphanSibling extends Model 
{

    protected $table = 'orphan_sibling';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('orphan_id', 'first_name', 'last_name', 'date_of_birth', 'relationship', 'details_en', 'details_ar');

    public function orphan()
    {
        return $this->belongsTo('Orphan', 'orphan_id');
    }

}